/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.model;

import com.github.restup.bind.converter.ParameterConverter;
import com.github.restup.bind.converter.ParameterConverterFactory;
import com.github.restup.controller.model.BasicParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.errors.ErrorCode;
import com.github.restup.errors.ErrorFactory;
import com.github.restup.errors.ErrorSource;
import com.github.restup.errors.Errors;
import com.github.restup.errors.RequestError;
import com.github.restup.mapping.fields.MappedField;
import com.github.restup.path.ResourcePath;
import com.github.restup.query.ResourceQueryStatement;
import com.github.restup.query.ResourceSort;
import com.github.restup.query.criteria.ResourcePathFilter;
import com.github.restup.query.criteria.ResourceQueryCriteria;
import com.github.restup.registry.Resource;
import com.github.restup.registry.ResourceRegistry;
import com.github.restup.service.model.ResourceData;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.list.SetUniqueList;

public interface ParsedResourceControllerRequest<T>
extends ResourceControllerRequest {
    public static <T> Builder<T> builder(ResourceRegistry registry, ResourceControllerRequest request) {
        return new Builder(registry, request);
    }

    public T getData();

    public List<ResourcePath> getRequestedPaths();

    public List<ResourceQueryStatement> getRequestedQueries();

    public String getPageLimitParameterName();

    public String getPageOffsetParameterName();

    public List<String> getAcceptedParameterNames();

    public boolean isPageOffsetOneBased();

    public static class Builder<T>
    implements Errors {
        private final ResourceRegistry registry;
        private final ResourceControllerRequest request;
        private ResourceData<T> body;
        private T data;
        private List<ResourcePath> requestedPaths;
        private Map<String, ResourceQueryStatement.Builder> resourceQueries;
        private List<String> acceptedParameterNames;
        private String pageLimitParameterName;
        private String pageOffsetParameterName;
        private boolean pageOffsetOneBased;
        private Integer pageLimit;
        private Integer pageOffset;
        private Errors errors;
        private int maxPageSize = 100;

        Builder(ResourceRegistry registry, ResourceControllerRequest request) {
            this.request = request;
            this.registry = registry;
            this.acceptedParameterNames = new ArrayList<String>();
        }

        private Builder<T> me() {
            return this;
        }

        public T getData() {
            return this.data;
        }

        public Builder<T> setData(T data) {
            this.data = data;
            return this.me();
        }

        private ResourcePath.Builder builder() {
            return this.builder(this.getResource());
        }

        private ResourcePath.Builder builder(Resource<?, ?> resource) {
            return ResourcePath.builder(resource).setQuiet(true);
        }

        private ResourcePath path(Integer index, MappedField<?> field) {
            return this.builder().data(index.intValue()).append(field).build();
        }

        private ResourcePath path(MappedField<?> field) {
            return this.builder().append(field).build();
        }

        private ResourcePath path(Resource<?, ?> resource, String field) {
            return this.builder(resource).path(field).build();
        }

        public Builder<T> addRequestedPath(Integer index, MappedField<?> field) {
            if (index == null) {
                return this.addRequestedPath(field);
            }
            return this.addRequestedPath(this.path(index, field));
        }

        public Builder<T> addRequestedPath(MappedField<?> field) {
            return this.addRequestedPath(this.path(field));
        }

        public Builder<T> addRequestedPath(ResourcePath path) {
            if (this.requestedPaths == null) {
                this.requestedPaths = SetUniqueList.setUniqueList(new ArrayList());
            }
            this.requestedPaths.add(path);
            return this.me();
        }

        public Builder<T> addAcceptedParameterName(String p) {
            this.acceptedParameterNames.add(p);
            return this.me();
        }

        public Builder<T> addSort(String rawParameterName, String rawParameterValue, String field, Boolean asc) {
            return this.addSort(rawParameterName, rawParameterValue, this.getResource(), field, asc);
        }

        private Builder<T> addSort(String rawParameterName, String rawParameterValue, Resource<?, ?> resource, String field, Boolean asc) {
            ResourcePath path = this.path(resource, field);
            if (!this.validatePath(rawParameterName, rawParameterValue, path, resource, field)) {
                return this.me();
            }
            return this.addSort(ResourceSort.of((ResourcePath)path, (Boolean)asc));
        }

        public void addFilter(List<ResourcePath> paths, Collection<Object> joinIds) {
            ResourceQueryStatement.Builder builder = this.getOrCreateQuery(this.getResource());
            builder.addCriteria(paths, joinIds);
        }

        private Builder<T> addFilter(ResourceQueryCriteria filter) {
            ResourceQueryStatement.Builder builder = this.getOrCreateQuery(this.getResource());
            builder.addCriteria(filter);
            return this.me();
        }

        private Builder<T> addSort(ResourceSort resourceSort) {
            ResourceQueryStatement.Builder builder = this.getOrCreateQuery(this.getResource());
            builder.addSort(resourceSort);
            return this.me();
        }

        public Builder<T> setFieldRequest(String rawParameterName, String rawParameterValue, Resource<?, ?> resource, ResourceQueryStatement.Type type) {
            ResourceQueryStatement.Builder builder = this.getOrCreateQuery(resource);
            return this.setType(rawParameterName, rawParameterValue, builder, type);
        }

        public Builder<T> setFieldRequest(String rawParameterName, String rawParameterValue, String resource, ResourceQueryStatement.Type type) {
            ResourceQueryStatement.Builder builder = this.getOrCreateQuery(rawParameterName, rawParameterValue, resource);
            return this.setType(rawParameterName, rawParameterValue, builder, type);
        }

        private Builder<T> setType(String rawParameterName, String rawParameterValue, ResourceQueryStatement.Builder builder, ResourceQueryStatement.Type type) {
            if (builder != null) {
                builder.setType(type);
            }
            return this.me();
        }

        public Builder<T> addIncludeJoinPaths(String rawParameterName, String rawParameterValue, String resource, String field) {
            ResourceQueryStatement.Builder builder = this.getOrCreateQuery(rawParameterName, rawParameterValue, resource);
            if (builder != null) {
                builder.addIncludeJoinPaths(this.getResource(), field);
            }
            return this.me();
        }

        public Builder<T> addRequestedField(String rawParameterName, String rawParameterValue, String resource, String field) {
            ResourceQueryStatement.Builder builder = this.getOrCreateQuery(rawParameterName, rawParameterValue, resource);
            if (builder != null) {
                builder.addRequestedPaths(new String[]{field});
            }
            return this.me();
        }

        public Builder<T> addAdditionalField(String rawParameterName, String rawParameterValue, String resource, String field) {
            ResourceQueryStatement.Builder builder = this.getOrCreateQuery(rawParameterName, rawParameterValue, resource);
            if (builder != null) {
                builder.addRequestedPathsAdded(new String[]{field});
            }
            return this.me();
        }

        public Builder<T> addExcludedField(String rawParameterName, String rawParameterValue, String resource, String field) {
            ResourceQueryStatement.Builder builder = this.getOrCreateQuery(rawParameterName, rawParameterValue, resource);
            if (builder != null) {
                builder.addRequestedPathsExcluded(field);
            }
            return this.me();
        }

        private Resource<?, ?> getResource(String rawParameterName, String rawParameterValue, String resourceName) {
            Resource resource = this.registry.getResource(resourceName);
            if (resource == null) {
                this.addError(this.getParameterError(rawParameterName, rawParameterValue).code(ErrorCode.UNKNOWN_RESOURCE).detail("Unknown resource specified for parameter {0}", new Object[]{rawParameterName}));
            }
            return resource;
        }

        private ResourceQueryStatement.Builder getOrCreateQuery(String rawParameterName, String rawParameterValue, String resourceName) {
            ResourceQueryStatement.Builder builder = this.getQuery(resourceName);
            if (builder == null) {
                Resource<?, ?> resource = this.getResource(rawParameterName, rawParameterValue, resourceName);
                builder = this.getOrCreateQuery(resource);
            }
            return builder;
        }

        private ResourceQueryStatement.Builder getOrCreateQuery(Resource<?, ?> resource) {
            ResourceQueryStatement.Builder builder = this.getQuery(resource);
            if (builder == null && resource != null) {
                builder = ResourceQueryStatement.builder(resource, (Errors)this);
                if (this.resourceQueries == null) {
                    this.resourceQueries = new HashMap<String, ResourceQueryStatement.Builder>();
                }
                this.resourceQueries.put(resource.getName(), builder);
            }
            return builder;
        }

        private ResourceQueryStatement.Builder getQuery(Resource<?, ?> resource) {
            ResourceQueryStatement.Builder builder = null;
            if (resource != null) {
                return this.getQuery(resource.getName());
            }
            return builder;
        }

        private ResourceQueryStatement.Builder getQuery(String resourceName) {
            return this.resourceQueries == null ? null : this.resourceQueries.get(resourceName);
        }

        public Builder<T> addFilter(String rawParameterName, String rawParameterValue, String field, String operator, String value) {
            ResourcePathFilter.Operator op = ResourcePathFilter.Operator.of((String)operator);
            if (op == null) {
                this.addError(this.getParameterError(rawParameterName, value).code("INVALID_OPERATOR").title("Invalid operator specified ").detail("{0} specifies an invalid operator, '{1}'", new Object[]{rawParameterName, operator}));
                return this.me();
            }
            return this.addFilter(rawParameterName, (Object)rawParameterValue, field, op, value);
        }

        public Builder<T> addFilter(String rawParameterName, Object rawParameterValue, String field, ResourcePathFilter.Operator operator, Collection<?> value) {
            return this.addFilterInternal(rawParameterName, rawParameterValue, field, operator, value);
        }

        public Builder<T> addFilter(String rawParameterName, Object rawParameterValue, String field, ResourcePathFilter.Operator operator, String value) {
            return this.addFilterInternal(rawParameterName, rawParameterValue, field, operator, value);
        }

        private Builder<T> addFilterInternal(String rawParameterName, Object rawParameterValue, String field, ResourcePathFilter.Operator operator, String value) {
            Resource<?, ?> resource = this.getResource();
            ResourcePath path = this.path(resource, field);
            if (!this.validatePath(rawParameterName, rawParameterValue, path, resource, field)) {
                return this.me();
            }
            Object converted = this.convertValue(path, value, rawParameterName);
            return this.addFilter((ResourceQueryCriteria)new ResourcePathFilter(path, operator, converted));
        }

        private Builder<T> addFilterInternal(String rawParameterName, Object rawParameterValue, String field, ResourcePathFilter.Operator operator, Collection<?> value) {
            Resource<?, ?> resource = this.getResource();
            ResourcePath path = this.path(resource, field);
            if (!this.validatePath(rawParameterName, rawParameterValue, path, resource, field)) {
                return this.me();
            }
            List converted = value.stream().map(v -> this.convertValue(path, v, rawParameterName)).collect(Collectors.toList());
            return this.addFilter((ResourceQueryCriteria)new ResourcePathFilter(path, operator, converted));
        }

        private Object convertValue(ResourcePath path, Object value, String parameterName) {
            MappedField mf;
            if (value instanceof String && (mf = path.lastMappedField()) != null) {
                Type type = mf.getType();
                ParameterConverterFactory factory = this.registry.getSettings().getParameterConverterFactory();
                ParameterConverter converter = factory.getConverter(type);
                if (converter != null) {
                    return converter.convert(parameterName, value, (Errors)this);
                }
            }
            return value;
        }

        private <ID extends Serializable> boolean validatePath(String rawParameterName, Object rawParameterValue, ResourcePath path, Resource<?, ?> resource, String field) {
            if (!path.isValid()) {
                this.addError(this.getParameterError(rawParameterName, rawParameterValue).code("INVALID_PARAMETER_PATH").title("Invalid path specified ").detail("{0} specifies an invalid field, '{1}', for {2} resources", new Object[]{rawParameterName, field, resource}));
                return false;
            }
            return true;
        }

        public Builder<T> setPageLimit(String parameterName, Integer value) {
            if (this.pageLimit != null) {
                this.addDuplicateParameter(parameterName, value, this.pageLimitParameterName, this.pageLimit);
            } else {
                if (this.hasMinError(parameterName, 0, value)) {
                    return this.me();
                }
                if (this.hasMaxError(parameterName, this.maxPageSize, value)) {
                    return this.me();
                }
                this.pageLimit = value;
                this.pageLimitParameterName = parameterName;
                ResourceQueryStatement.Builder builder = this.getOrCreateQuery(this.getResource());
                builder.setPageLimit(value);
            }
            return this.me();
        }

        public Builder<T> setPageOffset(String parameterName, Integer value) {
            return this.setPageOffset(parameterName, value, false);
        }

        public Builder<T> setPageOffset(String parameterName, Integer value, boolean pageOffsetAsOneBased) {
            this.pageOffsetOneBased = pageOffsetAsOneBased;
            if (this.pageOffset != null) {
                this.addDuplicateParameter(parameterName, value, this.pageOffsetParameterName, this.pageOffset);
            } else {
                if (this.hasMinError(parameterName, 0, value)) {
                    return this.me();
                }
                this.pageOffset = value;
                this.pageOffsetParameterName = parameterName;
                ResourceQueryStatement.Builder builder = this.getOrCreateQuery(this.getResource());
                builder.setPageOffset(value);
            }
            return this.me();
        }

        private boolean hasMaxError(String parameterName, int maxValue, Integer actualValue) {
            if (actualValue > maxValue) {
                this.addError(this.getParameterError(parameterName, actualValue).code("MAX_" + parameterName.toUpperCase()).title("Max exceeded").detail("Maximum allowable {0} is {1}", new Object[]{parameterName, maxValue}));
                return true;
            }
            return false;
        }

        private boolean hasMinError(String parameterName, int minValue, Integer actualValue) {
            if (actualValue == null || actualValue < minValue) {
                this.addError(this.getParameterError(parameterName, actualValue).code("MIN_" + parameterName.toUpperCase()).title("Minimum error").detail("Minimum allowable value for {0} is {1}", new Object[]{parameterName, minValue}));
                return true;
            }
            return false;
        }

        private void addDuplicateParameter(String parameterName, Integer value, String existingParameterName, Integer existingValue) {
            this.addError(this.getParameterError(parameterName, value).code("DUPLICATE_PARAMETER").title("Parameter value already specified").detail("{0} was already specified using '{1}={2}'", new Object[]{parameterName, existingParameterName, String.valueOf(existingValue)}).meta("existingParameterName", (Object)existingParameterName).meta("existingValue", (Object)existingValue));
        }

        public void addParameterError(String parameterName, Object value) {
            this.addError(this.getParameterError(parameterName, value));
        }

        private RequestError.Builder getParameterError(String parameterName, Object value) {
            return RequestError.builder().code("INVALID_PARAMETER").title("Invalid parameter value").detail("'{0}' is not a valid value for {1}", new Object[]{value, parameterName}).source((ErrorSource)this.getErrorFactory().createParameterError(parameterName, value));
        }

        public ErrorFactory getErrorFactory() {
            return this.registry.getSettings().getErrorFactory();
        }

        private Resource<?, ?> getResource() {
            return this.request.getResource();
        }

        public void addError(RequestError.Builder b) {
            if (b != null) {
                if (this.errors == null) {
                    this.errors = this.getErrorFactory().createErrors();
                }
                this.errors.addError(b.resource(this.getResource()));
            }
        }

        public void addError(ErrorCode code) {
            this.addError(RequestError.builder().code(code).resource(this.getResource()));
        }

        public List<RequestError> getErrors() {
            return this.errors == null ? null : this.errors.getErrors();
        }

        public boolean hasErrors() {
            return this.errors == null ? false : this.errors.hasErrors();
        }

        public void assertErrors() {
            if (this.errors != null) {
                this.errors.assertErrors();
            }
        }

        public ParsedResourceControllerRequest<T> build() {
            ResourceQueryStatement.Builder mediaTypes;
            this.assertErrors();
            ArrayList<ResourceQueryStatement> queries = null;
            if (this.resourceQueries != null) {
                queries = new ArrayList<ResourceQueryStatement>(this.resourceQueries.size());
                for (ResourceQueryStatement.Builder b : this.resourceQueries.values()) {
                    b.setPagingEnabled(true);
                    queries.add(b.build());
                }
            }
            if ((mediaTypes = this.request.getParameter("mediaType")) != null) {
                for (ResourceQueryStatement.Builder s : mediaTypes) {
                    if (!Objects.equals(s, this.request.getContentType())) continue;
                    this.addAcceptedParameterName("mediaType");
                }
            }
            BasicParsedResourceControllerRequest<T> result = new BasicParsedResourceControllerRequest<T>(this.data, this.requestedPaths, queries, this.request, this.body, this.acceptedParameterNames, this.pageLimitParameterName, this.pageOffsetParameterName, this.pageOffsetOneBased);
            return result;
        }
    }
}

