/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.model.result;

import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.path.PathValue;
import com.github.restup.path.ResourcePath;
import com.github.restup.query.PreparedResourceQueryStatement;
import com.github.restup.query.ResourceQueryStatement;
import com.github.restup.registry.Resource;
import com.github.restup.service.model.ResourceData;
import com.github.restup.service.model.response.PagedResult;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class NegotiatedResult {
    private final ParsedResourceControllerRequest<?> request;
    private final Object result;
    private final Map<Resource<?, ?>, Map<PathValue, Map<PathValue, ?>>> mappedPaths;

    protected NegotiatedResult(ParsedResourceControllerRequest<?> request, Object result) {
        this.request = request;
        this.result = result;
        this.mappedPaths = this.map();
    }

    public boolean isCount() {
        if (this.result instanceof PagedResult) {
            PagedResult paged = (PagedResult)this.result;
            return paged.getData() == null && paged.getLimit() == null && paged.getOffset() == null && paged.getTotal() != null;
        }
        return false;
    }

    protected Map<Resource<?, ?>, Map<PathValue, Map<PathValue, ?>>> map() {
        HashMap result = new HashMap();
        for (ResourceQueryStatement query : this.request.getRequestedQueries()) {
            this.map(result, query.getResource());
        }
        if (!result.containsKey(this.request.getResource())) {
            this.map(result, this.request.getResource());
        }
        return result;
    }

    protected void map(Map<Resource<?, ?>, Map<PathValue, Map<PathValue, ?>>> result, Resource<?, ?> resource) {
        List<ResourcePath> sparseFields = this.getSparseFields(resource);
        result.put(resource, this.map(sparseFields));
    }

    private Map<PathValue, Map<PathValue, ?>> map(List<ResourcePath> sparseFields) {
        LinkedHashMap map = new LinkedHashMap();
        for (ResourcePath path : sparseFields) {
            this.map(map, path.firstMappedFieldPath());
        }
        return map;
    }

    private void map(Map<PathValue, Map<PathValue, ?>> map, ResourcePath path) {
        PathValue pv;
        if (path != null && !(pv = path.value()).isReservedPath()) {
            ResourcePath next = path.next();
            if (next != null) {
                Map<PathValue, Map<PathValue, ?>> existing = map.get(pv);
                if (existing == null) {
                    existing = new LinkedHashMap();
                    map.put(pv, existing);
                }
                this.map(existing, next);
            } else {
                map.put(pv, null);
            }
        }
    }

    protected List<ResourcePath> getSparseFields(Resource<?, ?> resource) {
        ResourceQueryStatement query = ResourceQueryStatement.getQuery(resource, this.request.getRequestedQueries());
        return PreparedResourceQueryStatement.sparseFields(resource, (ResourceQueryStatement)query);
    }

    public Resource<?, ?> getResource() {
        return this.request.getResource();
    }

    public Object getData() {
        if (this.result instanceof ResourceData) {
            return ((ResourceData)this.result).getData();
        }
        return this.result;
    }

    public Map<PathValue, Map<PathValue, ?>> getMappedPaths() {
        return this.getMappedPaths(this.getResource());
    }

    public Map<PathValue, Map<PathValue, ?>> getMappedPaths(Resource<?, ?> resource) {
        return this.mappedPaths.get(resource);
    }

    public ParsedResourceControllerRequest<?> getRequest() {
        return this.request;
    }

    public Object getResult() {
        return this.result;
    }
}

