/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.request.parser;

import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.request.parser.RequestParser;
import com.github.restup.errors.ErrorCode;
import com.github.restup.path.ResourcePath;
import com.github.restup.registry.Resource;
import com.github.restup.registry.settings.ControllerMethodAccess;
import com.github.restup.service.model.ResourceData;

public abstract class AbstractRequestBodyParser<T>
implements RequestParser {
    protected static ResourcePath.Builder path(ResourcePath parent, ParsedResourceControllerRequest.Builder<?> builder, String fieldName) {
        return AbstractRequestBodyParser.path(parent).setErrors(builder).append(fieldName);
    }

    protected static ResourcePath.Builder path(ResourcePath parent) {
        return ResourcePath.builder((ResourcePath)parent).setMode(ResourcePath.Builder.Mode.API).setQuiet(true);
    }

    public void parse(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder builder) {
        Resource<?, ?> resource = request.getResource();
        T body = this.getBody(request);
        if (body == null) {
            if (request.getMethod().requiresData()) {
                builder.addError(ErrorCode.BODY_REQUIRED);
            }
            return;
        }
        if (this.isArray(body)) {
            ControllerMethodAccess controllerMethodAccess = resource.getControllerMethodAccess();
            if (!request.getMethod().supportsMultiple(controllerMethodAccess)) {
                builder.addError(ErrorCode.BODY_ARRAY_NOT_SUPPORTED);
                return;
            }
        }
        ResourcePath path = ResourcePath.builder(resource).data().build();
        this.graph(request, builder, resource, path, body);
        if (!builder.hasErrors()) {
            Object deserialized = this.deserializeBody(request, builder, body);
            deserialized = Resource.validate(resource, (Object)deserialized);
            builder.setData(deserialized);
        }
    }

    protected abstract boolean isArray(T var1);

    protected abstract boolean isObject(T var1);

    protected abstract Object deserializeArray(ResourceControllerRequest var1, ParsedResourceControllerRequest.Builder<?> var2, T var3);

    protected abstract Object deserializeObject(ResourceControllerRequest var1, ParsedResourceControllerRequest.Builder<?> var2, T var3);

    protected abstract void graphArray(ResourceControllerRequest var1, ParsedResourceControllerRequest.Builder<?> var2, Resource<?, ?> var3, ResourcePath var4, T var5);

    protected abstract void graphObject(ResourceControllerRequest var1, ParsedResourceControllerRequest.Builder<?> var2, Resource<?, ?> var3, ResourcePath var4, T var5);

    protected Object deserializeBody(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<?> builder, T body) {
        if (this.isArray(body)) {
            return this.deserializeArray(request, builder, body);
        }
        return this.deserializeObject(request, builder, body);
    }

    protected void graph(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<?> builder, Resource<?, ?> resource, ResourcePath parent, T node) {
        if (parent.isValid()) {
            if (this.isArray(node)) {
                this.graphArray(request, builder, resource, parent, node);
            } else if (this.isObject(node)) {
                this.graphObject(request, builder, resource, parent, node);
            } else {
                builder.addRequestedPath(parent);
            }
        } else {
            builder.addRequestedPath(parent);
        }
    }

    private T getBody(ResourceControllerRequest request) {
        ResourceData<?> body = request.getBody();
        return (T)(body == null ? null : body.getData());
    }
}

