/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.request.parser;

import com.github.restup.controller.model.MediaType;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.request.parser.NoOpRequestParser;
import com.github.restup.controller.request.parser.RequestParser;
import com.github.restup.util.Assert;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ContentNegotiatedRequestParser
implements RequestParser {
    private final Map<String, RequestParser> parsers;
    private final RequestParser defaultParser;
    private final String defaultMediaType;

    ContentNegotiatedRequestParser(Map<String, RequestParser> parsers, RequestParser defaultParser, String defaultMediaType) {
        Assert.notEmpty(parsers, (String)"parsers cannot be empty");
        Assert.notNull((Object)defaultParser, (String)"default parser is required");
        this.parsers = parsers;
        this.defaultParser = defaultParser;
        this.defaultMediaType = defaultMediaType;
    }

    public static Builder builder() {
        return new Builder();
    }

    private String getContentType(ResourceControllerRequest request) {
        String result = request.getContentType();
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = this.defaultMediaType;
        }
        return result;
    }

    @Override
    public void parse(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<?> builder) {
        RequestParser parser = this.parsers.get(this.getContentType(request));
        if (parser == null) {
            parser = this.defaultParser;
        }
        parser.parse(request, builder);
    }

    public static final class Builder {
        private Map<String, RequestParser> parsers = new HashMap<String, RequestParser>();
        private RequestParser defaultParser;
        private String defaultMediaType;

        private Builder() {
        }

        private Builder me() {
            return this;
        }

        public Builder addParser(MediaType contentType, RequestParser parser) {
            this.parsers.put(contentType.getContentType(), parser);
            return this.me();
        }

        public Builder defaultParser(RequestParser defaultParser) {
            this.defaultParser = defaultParser;
            return this.me();
        }

        public Builder defaultMediaType(String defaultMediaType) {
            this.defaultMediaType = defaultMediaType;
            return this.me();
        }

        public ContentNegotiatedRequestParser build() {
            RequestParser requestParser = this.defaultParser;
            if (requestParser == null) {
                requestParser = new NoOpRequestParser();
            }
            return new ContentNegotiatedRequestParser(this.parsers, requestParser, this.defaultMediaType);
        }
    }
}

