/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.request.parser;

import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.request.parser.RequestParser;
import com.github.restup.query.ResourceQuery;
import com.github.restup.registry.ResourceRelationship;
import java.util.Collection;

public class DefaultRelationshipsParser
implements RequestParser {
    @Override
    public void parse(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<?> builder) {
        ResourceRelationship<?, ?, ?, ?> relationship;
        if (!builder.hasErrors() && (relationship = request.getResourceRelationship()) != null) {
            Collection<Object> joinIds = request.getIds();
            if (relationship.isFrom(request.getRelationship())) {
                Object result = ResourceQuery.find(request.getRelationship(), (Object)this.getId(request));
                joinIds = relationship.getIds(result);
                builder.addFilter(relationship.getToPaths(), joinIds);
            } else {
                builder.addFilter(relationship.getFromPaths(), joinIds);
            }
        }
    }

    Object getId(ResourceControllerRequest request) {
        return request.getIds().iterator().next();
    }
}

