/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.request.parser;

import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.request.parser.RequestParamParser;
import com.github.restup.controller.request.parser.RequestParser;
import com.github.restup.controller.request.parser.params.FieldsParser;
import com.github.restup.controller.request.parser.params.FilterParser;
import com.github.restup.controller.request.parser.params.IncludeParser;
import com.github.restup.controller.request.parser.params.PageLimitParser;
import com.github.restup.controller.request.parser.params.PageNumberParser;
import com.github.restup.controller.request.parser.params.PageOffsetParser;
import com.github.restup.controller.request.parser.params.SortParamParser;
import com.github.restup.util.Assert;
import java.util.List;

public class ParameterParserChain
implements RequestParser {
    private final RequestParamParser[] parsers;

    public static ParameterParserChain of(List<RequestParamParser> parsers) {
        return ParameterParserChain.of(parsers.toArray(new RequestParamParser[parsers.size()]));
    }

    public static ParameterParserChain of(RequestParamParser ... parsers) {
        return new ParameterParserChain(parsers);
    }

    public ParameterParserChain(RequestParamParser ... parsers) {
        Assert.notEmpty((String)"parsers are required", (Object[])parsers);
        this.parsers = parsers;
    }

    public ParameterParserChain() {
        this(new PageOffsetParser(), new PageLimitParser(), new SortParamParser(), new FilterParser(), new IncludeParser(), new FieldsParser(), new PageNumberParser("page"), new PageLimitParser("rpp"), new PageNumberParser(), new PageLimitParser("pageSize"), new PageNumberParser("pageNo"), new PageNumberParser("pageNum"), new FilterParser("f"), new FilterParser("q"));
    }

    @Override
    public void parse(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<?> builder) {
        List params = request.getParameterNames();
        if (params != null) {
            block0: for (String param : params) {
                if (param == null) continue;
                for (RequestParamParser parser : this.parsers) {
                    if (!parser.accept(param)) continue;
                    builder.addAcceptedParameterName(param);
                    parser.parse(request, builder, param, request.getParameter(param));
                    continue block0;
                }
            }
        }
    }

    RequestParamParser[] getParsers() {
        return this.parsers;
    }
}

