/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.request.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.request.parser.DefaultRelationshipsParser;
import com.github.restup.controller.request.parser.ParameterParserChain;
import com.github.restup.controller.request.parser.RequestParamParser;
import com.github.restup.controller.request.parser.RequestParserChain;
import com.github.restup.controller.request.parser.params.FieldsParser;
import com.github.restup.controller.request.parser.params.FilterParser;
import com.github.restup.controller.request.parser.params.IncludeParser;
import com.github.restup.controller.request.parser.params.PageLimitParser;
import com.github.restup.controller.request.parser.params.PageNumberParser;
import com.github.restup.controller.request.parser.params.PageOffsetParser;
import com.github.restup.controller.request.parser.params.SortParamParser;
import com.github.restup.controller.settings.BuilderSettingsCaptor;
import com.github.restup.jackson.JacksonConfiguration;
import com.github.restup.registry.settings.AutoDetectConstants;
import com.github.restup.util.Streams;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public interface RequestParser {
    public static Builder builder() {
        return new Builder();
    }

    public void parse(ResourceControllerRequest var1, ParsedResourceControllerRequest.Builder<?> var2);

    public static class Builder {
        private RequestParser[] requestParsers = new RequestParser[0];
        private RequestParamParser[] requestParamParsers = new RequestParamParser[0];
        private RequestParser relationshipParser;
        private String[] pageOffsetParamName = new String[]{"offset"};
        private String[] pageLimitParamName = new String[]{"limit", "pageSize", "rpp"};
        private String[] sortParamName = new String[]{"sort"};
        private String[] filterParamName = new String[]{"filter", "f", "q"};
        private String[] includeParamName = new String[]{"include"};
        private String[] fieldsParamName = new String[]{"fields"};
        private String[] pageNumberParamName = new String[]{"pageNumber", "page", "pageNo", "pageNum"};
        private ObjectMapper mapper;
        private BuilderSettingsCaptor settingsCaptor = new BuilderSettingsCaptor();

        Builder() {
        }

        Builder me() {
            return this;
        }

        public Builder pageOffsetParamName(String ... names) {
            this.pageOffsetParamName = names;
            return this.me();
        }

        public Builder pageLimitParamName(String ... names) {
            this.pageLimitParamName = names;
            return this.me();
        }

        public Builder sortParamName(String ... names) {
            this.sortParamName = names;
            return this.me();
        }

        public Builder filterParamName(String ... names) {
            this.filterParamName = names;
            return this.me();
        }

        public Builder includeParamName(String ... names) {
            this.includeParamName = names;
            return this.me();
        }

        public Builder fieldsParamName(String ... names) {
            this.fieldsParamName = names;
            return this.me();
        }

        public Builder pageNumberParamName(String ... names) {
            this.pageNumberParamName = names;
            return this.me();
        }

        public Builder requestParsers(RequestParser ... requestParsers) {
            this.requestParsers = requestParsers;
            return this.me();
        }

        public Builder relationshipParser(RequestParser relationshipParser) {
            this.relationshipParser = relationshipParser;
            return this.me();
        }

        public Builder requestParamParsers(RequestParamParser ... requestParamParsers) {
            this.requestParamParsers = requestParamParsers;
            return this.me();
        }

        public Builder jacksonObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this.me();
        }

        public Builder autoDetectDisabled(boolean autoDetectDisabled) {
            this.settingsCaptor.setAutoDetectDisabled(autoDetectDisabled);
            return this.me();
        }

        public Builder defaultMediaType(String mediaType) {
            this.settingsCaptor.setDefaultMediaType(mediaType);
            return this.me();
        }

        public Builder capture(BuilderSettingsCaptor settingsCaptor) {
            this.settingsCaptor = settingsCaptor.capture(this.settingsCaptor);
            return this.me();
        }

        public RequestParser build() {
            RequestParser relationshipsParser;
            this.settingsCaptor.build();
            ArrayList<RequestParamParser> paramParsers = new ArrayList<RequestParamParser>();
            Streams.forEachNonNull((Object[])this.requestParamParsers, p -> paramParsers.add((RequestParamParser)p));
            Streams.forEachNonNull((Object[])this.pageOffsetParamName, s -> paramParsers.add(new PageOffsetParser((String)s)));
            Streams.forEachNonNull((Object[])this.pageLimitParamName, s -> paramParsers.add(new PageLimitParser((String)s)));
            Streams.forEachNonNull((Object[])this.sortParamName, s -> paramParsers.add(new SortParamParser((String)s)));
            Streams.forEachNonNull((Object[])this.filterParamName, s -> paramParsers.add(new FilterParser((String)s)));
            Streams.forEachNonNull((Object[])this.includeParamName, s -> paramParsers.add(new IncludeParser((String)s)));
            Streams.forEachNonNull((Object[])this.fieldsParamName, s -> paramParsers.add(new FieldsParser((String)s)));
            Streams.forEachNonNull((Object[])this.pageNumberParamName, s -> paramParsers.add(new PageNumberParser((String)s)));
            ParameterParserChain parameterParserChain = ParameterParserChain.of(paramParsers);
            if (!this.settingsCaptor.getAutoDetectDisabled().booleanValue() && AutoDetectConstants.JACKSON2_EXISTS) {
                this.requestParsers(JacksonConfiguration.parser(this.mapper, this.settingsCaptor.getDefaultMediaType()));
            }
            if ((relationshipsParser = this.relationshipParser) == null) {
                relationshipsParser = new DefaultRelationshipsParser();
            }
            if (ArrayUtils.getLength((Object)this.requestParsers) == 0) {
                return new RequestParserChain(parameterParserChain, relationshipsParser);
            }
            return new RequestParserChain((RequestParser[])ArrayUtils.addAll((Object[])this.requestParsers, (Object[])new RequestParser[]{parameterParserChain, relationshipsParser}));
        }
    }
}

