/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.request.parser;

import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.request.parser.RequestParser;
import com.github.restup.util.Assert;

public class RequestParserChain
implements RequestParser {
    private final RequestParser[] parsers;

    public RequestParserChain(RequestParser ... parsers) {
        Assert.notEmpty((String)"parsers are required", (Object[])parsers);
        this.parsers = parsers;
    }

    @Override
    public void parse(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<?> builder) {
        for (RequestParser parser : this.parsers) {
            parser.parse(request, builder);
        }
    }

    RequestParser[] getParsers() {
        return this.parsers;
    }
}

