/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.request.parser.params;

import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.request.parser.params.AbstractRequestParamParser;
import com.github.restup.util.Assert;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDelimitedParamParser<P>
extends AbstractRequestParamParser<P> {
    private final String delimiter;

    public AbstractDelimitedParamParser(String parameterName, String delimiter, boolean ignoreNull, boolean ignoreBlank) {
        super(parameterName, ignoreNull, ignoreBlank);
        Assert.notNull((Object)delimiter, (String)"delimiter is required");
        this.delimiter = delimiter;
    }

    @Override
    public final <T> void apply(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<T> builder, P parsedParameterName, String parameterValue, String rawParamName, String rawValue) {
        String[] values;
        for (String value : values = parameterValue.split(this.delimiter)) {
            if (StringUtils.isBlank((CharSequence)value)) {
                if (this.isIgnoreBlank()) continue;
                builder.addParameterError(rawParamName, rawValue);
                continue;
            }
            this.applyDelimitedValue(request, builder, parsedParameterName, value.trim(), rawParamName, rawValue);
        }
    }

    abstract <T> void applyDelimitedValue(ResourceControllerRequest var1, ParsedResourceControllerRequest.Builder<T> var2, P var3, String var4, String var5, String var6);
}

