/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.request.parser.params;

import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.request.parser.RequestParamParser;
import com.github.restup.util.Assert;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRequestParamParser<P>
implements RequestParamParser {
    private final String parameterName;
    private final boolean ignoreNull;
    private final boolean ignoreBlank;

    protected AbstractRequestParamParser(String parameterName, boolean ignoreNull, boolean ignoreBlank) {
        Assert.notNull((Object)parameterName, (String)"parameterName is required");
        this.parameterName = parameterName;
        this.ignoreNull = ignoreNull;
        this.ignoreBlank = ignoreBlank;
    }

    protected AbstractRequestParamParser(String parameterName) {
        this(parameterName, false, false);
    }

    public static <T> String[] parseBracketedString(ParsedResourceControllerRequest.Builder<T> builder, String rawParameterName, Object rawValue, String targetString, int minPartSize, int maxPartSize) {
        String[] parts = targetString.split("\\[");
        if (parts.length < minPartSize || parts.length > maxPartSize || parts.length > 1 && !AbstractRequestParamParser.hasTrailingBracket(targetString)) {
            builder.addParameterError(rawParameterName, rawValue);
            return null;
        }
        for (int i = 1; i < parts.length; ++i) {
            parts[i] = AbstractRequestParamParser.removeBrackets(parts[i]);
        }
        return parts;
    }

    static boolean hasTrailingBracket(String s) {
        return s.length() > 1 && s.endsWith("]");
    }

    static String removeBrackets(String s) {
        if (AbstractRequestParamParser.hasTrailingBracket(s)) {
            return s.substring(0, s.length() - 1);
        }
        return null;
    }

    protected <T> P getParsedParameter(ResourceControllerRequest details, ParsedResourceControllerRequest.Builder<T> builder, String parameterName, String[] parameterValues) {
        return (P)parameterName;
    }

    abstract <T> void apply(ResourceControllerRequest var1, ParsedResourceControllerRequest.Builder<T> var2, P var3, String var4, String var5, String var6);

    @Override
    public <T> void parse(ResourceControllerRequest details, ParsedResourceControllerRequest.Builder<T> builder, String rawParamName, String[] parameterValues) {
        if (parameterValues == null || parameterValues.length < 1) {
            this.applyNonNull(builder, rawParamName);
        } else {
            P parsedParameterName = this.getParsedParameter(details, builder, rawParamName, parameterValues);
            if (parsedParameterName != null) {
                for (String rawValue : parameterValues) {
                    if (StringUtils.isBlank((CharSequence)rawValue)) {
                        if (this.isIgnoreBlank()) continue;
                        builder.addParameterError(rawParamName, rawValue);
                        continue;
                    }
                    this.apply(details, builder, parsedParameterName, rawValue.trim(), rawParamName, rawValue);
                }
            }
        }
    }

    protected <T> void applyNonNull(ParsedResourceControllerRequest.Builder<T> builder, String paramName) {
        if (!this.ignoreNull) {
            builder.addParameterError(paramName, null);
        }
    }

    @Override
    public boolean accept(String paramName) {
        return Objects.equals(paramName, this.parameterName);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public boolean isIgnoreBlank() {
        return this.ignoreBlank;
    }
}

