/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.settings;

import com.github.restup.controller.linking.LinkBuilderFactory;
import com.github.restup.controller.linking.discovery.CachedServiceDiscovery;
import com.github.restup.controller.linking.discovery.ServiceDiscovery;

public class BuilderSettingsCaptor {
    private LinkBuilderFactory linkBuilderFactory;
    private ServiceDiscovery serviceDiscovery;
    private Boolean autoDetectDisabled;
    private String defaultMediaType;

    public LinkBuilderFactory getLinkBuilderFactory() {
        return this.linkBuilderFactory;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public Boolean getAutoDetectDisabled() {
        return this.autoDetectDisabled;
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public BuilderSettingsCaptor capture(BuilderSettingsCaptor settingsCaptor) {
        this.setLinkBuilderFactory(settingsCaptor.getLinkBuilderFactory());
        this.setAutoDetectDisabled(settingsCaptor.getAutoDetectDisabled());
        this.setDefaultMediaType(settingsCaptor.getDefaultMediaType());
        this.setServiceDiscovery(settingsCaptor.getServiceDiscovery());
        return this;
    }

    public void setLinkBuilderFactory(LinkBuilderFactory linkBuilderFactory) {
        if (linkBuilderFactory != null) {
            this.linkBuilderFactory = linkBuilderFactory;
        }
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        if (serviceDiscovery != null) {
            this.serviceDiscovery = serviceDiscovery;
        }
    }

    public void setAutoDetectDisabled(Boolean autoDetectDisabled) {
        if (autoDetectDisabled != null) {
            this.autoDetectDisabled = autoDetectDisabled;
        }
    }

    public void setDefaultMediaType(String defaultMediaType) {
        if (defaultMediaType != null) {
            this.defaultMediaType = defaultMediaType;
        }
    }

    public void build() {
        ServiceDiscovery discovery = this.serviceDiscovery;
        LinkBuilderFactory factory = this.linkBuilderFactory;
        if (discovery == null) {
            this.serviceDiscovery = discovery = CachedServiceDiscovery.cache(ServiceDiscovery.getDefaultServiceDiscovery());
        }
        if (factory == null) {
            this.linkBuilderFactory = factory = LinkBuilderFactory.getDefaultLinkBuilderFactory(discovery);
        }
        if (this.autoDetectDisabled == null) {
            this.autoDetectDisabled = false;
        }
    }
}

