/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.settings;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.restup.controller.ExceptionHandler;
import com.github.restup.controller.content.negotiation.ContentNegotiator;
import com.github.restup.controller.interceptor.NoOpRequestInterceptor;
import com.github.restup.controller.interceptor.RequestInterceptor;
import com.github.restup.controller.interceptor.RequestInterceptorChain;
import com.github.restup.controller.linking.LinkBuilderFactory;
import com.github.restup.controller.linking.discovery.ServiceDiscovery;
import com.github.restup.controller.request.parser.RequestParser;
import com.github.restup.controller.settings.BasicControllerSettings;
import com.github.restup.controller.settings.BuilderSettingsCaptor;
import com.github.restup.mapping.MappedClass;
import com.github.restup.registry.Resource;
import com.github.restup.registry.ResourceRegistry;
import com.github.restup.service.registry.DiscoveryService;
import org.apache.commons.lang3.ArrayUtils;

public interface ControllerSettings {
    public static Builder builder() {
        return new Builder();
    }

    public String getDefaultMediaType();

    public ResourceRegistry getRegistry();

    public ContentNegotiator getContentNegotiator();

    public RequestInterceptor getRequestInterceptor();

    public RequestParser getRequestParser();

    public ExceptionHandler getExceptionHandler();

    public static class Builder {
        private ResourceRegistry registry;
        private ContentNegotiator contentNegotiator;
        private RequestInterceptor[] interceptors;
        private RequestParser requestParser;
        private ExceptionHandler exceptionHandler;
        private ObjectMapper mapper;
        private BuilderSettingsCaptor settingsCaptor = new BuilderSettingsCaptor();

        private Builder() {
        }

        private static RequestInterceptor getInterceptor(RequestInterceptor[] interceptors) {
            RequestInterceptor[] arr = interceptors;
            int size = ArrayUtils.getLength((Object)arr);
            if (size == 0) {
                return new NoOpRequestInterceptor();
            }
            if (size == 1) {
                return arr[0];
            }
            return new RequestInterceptorChain(arr);
        }

        private Builder me() {
            return this;
        }

        public Builder registry(ResourceRegistry registry) {
            this.registry = registry;
            return this.me();
        }

        public Builder contentNegotiator(ContentNegotiator contentNegotiator) {
            this.contentNegotiator = contentNegotiator;
            return this.me();
        }

        public Builder contentNegotiator(ContentNegotiator.Builder contentNegotiator) {
            return this.contentNegotiator(contentNegotiator.capture(this.settingsCaptor).build());
        }

        public Builder interceptors(RequestInterceptor ... interceptors) {
            this.interceptors = interceptors;
            return this.me();
        }

        public Builder requestParser(RequestParser.Builder requestParser) {
            return this.requestParser(requestParser.capture(this.settingsCaptor).build());
        }

        public Builder requestParser(RequestParser requestParser) {
            this.requestParser = requestParser;
            return this.me();
        }

        public Builder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this.me();
        }

        public Builder jacksonObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this.me();
        }

        public Builder serviceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.settingsCaptor.setServiceDiscovery(serviceDiscovery);
            return this.me();
        }

        public Builder linkBuilderFactory(LinkBuilderFactory linkBuilderFactory) {
            this.settingsCaptor.setLinkBuilderFactory(linkBuilderFactory);
            return this.me();
        }

        public Builder autoDetectDisabled(boolean autoDetectDisabled) {
            this.settingsCaptor.setAutoDetectDisabled(autoDetectDisabled);
            return this.me();
        }

        public Builder defaultMediaType(String mediaType) {
            this.settingsCaptor.setDefaultMediaType(mediaType);
            return this.me();
        }

        public ControllerSettings build() {
            ExceptionHandler exceptionHandler;
            ContentNegotiator contentNegotiator;
            this.settingsCaptor.build();
            RequestInterceptor interceptor = Builder.getInterceptor(this.interceptors);
            RequestParser requestParser = this.requestParser;
            if (requestParser == null) {
                requestParser = RequestParser.builder().capture(this.settingsCaptor).jacksonObjectMapper(this.mapper).build();
            }
            if ((contentNegotiator = this.contentNegotiator) == null) {
                contentNegotiator = ContentNegotiator.builder().capture(this.settingsCaptor).build();
            }
            if ((exceptionHandler = this.exceptionHandler) == null) {
                exceptionHandler = ExceptionHandler.getDefaultInstance();
            }
            this.registry.registerResource(Resource.builder(Resource.class).service((Object)new DiscoveryService(this.settingsCaptor.getLinkBuilderFactory())).excludeFrameworkFilters(true).mapping(MappedClass.builder(Resource.class).name("Up!ResourceDiscovery").pluralName("resources").id(String.class, "name")));
            return new BasicControllerSettings(this.registry, contentNegotiator, interceptor, requestParser, exceptionHandler, this.settingsCaptor.getDefaultMediaType());
        }
    }
}

