/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.jackson.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.restup.controller.model.HttpMethod;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.errors.ErrorCode;
import com.github.restup.errors.RequestError;
import com.github.restup.jackson.parser.JacksonRequestBodyParser;
import com.github.restup.path.ResourcePath;
import com.github.restup.registry.Resource;
import java.util.Iterator;

public class JacksonJsonApiRequestBodyParser
extends JacksonRequestBodyParser {
    public JacksonJsonApiRequestBodyParser(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    protected void graphObject(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<?> builder, Resource<?, ?> resource, ResourcePath parent, JsonNode node) {
        JsonNode id = null;
        JsonNode type = null;
        JsonNode attributes = null;
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            if (fieldName.equals("id")) {
                id = node.get("id");
                continue;
            }
            if (fieldName.equals("type")) {
                type = node.get("type");
                continue;
            }
            if (fieldName.equals("attributes")) {
                attributes = node.get("attributes");
                continue;
            }
            ResourcePath.Builder path = JacksonJsonApiRequestBodyParser.path(parent, builder, fieldName);
            if (path.isInvalid()) continue;
            builder.addError(RequestError.builder((ResourcePath)path.build()).code(ErrorCode.WRAP_FIELDS_WITH_ATTRIBUTES));
        }
        if (id == null && !HttpMethod.POST.equals((Object)request.getMethod())) {
            builder.addError(RequestError.builder((ResourcePath)parent).code(ErrorCode.ID_REQUIRED));
        }
        if (type == null) {
            builder.addError(RequestError.builder((ResourcePath)parent).code(ErrorCode.TYPE_REQUIRED));
        }
        super.graphObject(request, builder, resource, parent, attributes);
    }

    @Override
    protected Object deserializeObject(ResourceControllerRequest details, ParsedResourceControllerRequest.Builder<?> builder, JsonNode node) {
        try {
            Resource<?, ?> resource = details.getResource();
            ObjectNode attributes = (ObjectNode)node.get("attributes");
            attributes.set("id", node.get("id"));
            if (resource.hasApiField("type")) {
                attributes.set("type", node.get("type"));
            }
            return this.mapper.treeToValue((TreeNode)attributes, resource.getClassType());
        }
        catch (JsonProcessingException e) {
            builder.addError(ErrorCode.BODY_INVALID);
            return null;
        }
    }
}

