/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.jackson.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.request.parser.AbstractRequestBodyParser;
import com.github.restup.errors.ErrorCode;
import com.github.restup.path.ResourcePath;
import com.github.restup.registry.Resource;
import java.util.ArrayList;
import java.util.Iterator;

public class JacksonRequestBodyParser
extends AbstractRequestBodyParser<JsonNode> {
    protected final ObjectMapper mapper;

    public JacksonRequestBodyParser(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public JacksonRequestBodyParser() {
        this(new ObjectMapper());
    }

    @Override
    protected boolean isArray(JsonNode jsonNode) {
        return jsonNode.isArray();
    }

    @Override
    protected boolean isObject(JsonNode jsonNode) {
        return jsonNode.isObject();
    }

    @Override
    protected void graphArray(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<?> builder, Resource<?, ?> resource, ResourcePath parent, JsonNode node) {
        Iterator it = node.iterator();
        int i = 0;
        while (it.hasNext()) {
            JsonNode item = (JsonNode)it.next();
            ResourcePath path = JacksonRequestBodyParser.path(parent).index(i++).build();
            this.graph(request, builder, resource, path, item);
        }
    }

    @Override
    protected void graphObject(ResourceControllerRequest request, ParsedResourceControllerRequest.Builder<?> builder, Resource<?, ?> resource, ResourcePath parent, JsonNode node) {
        Iterator iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            ResourcePath path = JacksonRequestBodyParser.path(parent, builder, fieldName).build();
            JsonNode item = node.get(fieldName);
            this.graph(request, builder, resource, path, item);
        }
    }

    @Override
    protected Object deserializeObject(ResourceControllerRequest details, ParsedResourceControllerRequest.Builder<?> builder, JsonNode node) {
        try {
            return this.mapper.treeToValue((TreeNode)node, details.getResource().getClassType());
        }
        catch (JsonProcessingException e) {
            builder.addError(ErrorCode.BODY_INVALID);
            return null;
        }
    }

    @Override
    protected Object deserializeArray(ResourceControllerRequest details, ParsedResourceControllerRequest.Builder<?> builder, JsonNode node) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (JsonNode item : node) {
            result.add(this.deserializeObject(details, builder, item));
        }
        return result;
    }
}

