/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.github.restup.controller.linking.Link;
import com.github.restup.controller.model.result.JsonApiResult;
import com.github.restup.jackson.serializer.LinksSerializer;
import com.github.restup.jackson.serializer.NegotiatedResultSerializer;
import com.github.restup.mapping.fields.MappedField;
import com.github.restup.path.MappedFieldPathValue;
import com.github.restup.path.PathValue;
import com.github.restup.registry.Resource;
import com.github.restup.registry.ResourceRelationship;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class JsonApiResultSerializer
extends NegotiatedResultSerializer<JsonApiResult> {
    @Override
    protected void writeLinking(JsonApiResult result, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        List<Link> links = result.getTopLevelLinks();
        this.writeLinks(jgen, links);
    }

    @Override
    protected Object writeIdentifier(JsonGenerator jgen, String fieldName, Object id) throws IOException {
        String result = String.valueOf(id);
        jgen.writeStringField(fieldName, result);
        return result;
    }

    @Override
    protected void writeResourceObject(Resource<?, ?> resource, Map<PathValue, ?> paths, Object data, JsonApiResult result, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        jgen.writeStartObject();
        Object id = this.writeIdentifier(resource, data, result, jgen, provider);
        this.writeType(resource, data, result, jgen, provider);
        jgen.writeFieldName("attributes");
        jgen.writeStartObject();
        super.writeAttributes(resource, paths, data, result, jgen, provider, false);
        jgen.writeEndObject();
        this.writeResourceRelationships(resource, paths, data, result, jgen, provider);
        this.writeLinks(jgen, result.getLinks(resource, id));
        jgen.writeEndObject();
    }

    protected void writeResourceRelationships(Resource<?, ?> resource, Map<PathValue, ?> paths, Object data, JsonApiResult result, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        List relationships = resource.getRelationshipsTo();
        if (this.hasRelationships(paths) || CollectionUtils.isNotEmpty((Collection)relationships)) {
            jgen.writeFieldName("relationships");
            jgen.writeStartObject();
            Object id = resource.getIdentityField().readValue(data);
            for (Map.Entry<PathValue, ?> e : paths.entrySet()) {
                PathValue pv = e.getKey();
                if (!MappedFieldPathValue.isRelationshipField((PathValue)pv)) continue;
                MappedFieldPathValue mappedFieldPathValue = (MappedFieldPathValue)pv;
                MappedField mappedField = mappedFieldPathValue.getMappedField();
                Resource rel = resource.getRegistry().getResource(mappedField.getRelationshipResource(resource.getRegistry()));
                Object value = mappedFieldPathValue.readValue(data);
                jgen.writeFieldName(MappedField.getRelationshipName((MappedField)mappedField, (Resource)rel));
                jgen.writeStartObject();
                this.writeResourceIdentifierObject(jgen, rel, value);
                this.writeLinks(jgen, result.getRelationshipLinks(rel, id));
                jgen.writeEndObject();
            }
            if (CollectionUtils.isNotEmpty((Collection)relationships)) {
                for (ResourceRelationship relationship : relationships) {
                    jgen.writeFieldName(ResourceRelationship.getRelationshipNameForToResource((ResourceRelationship)relationship));
                    jgen.writeStartObject();
                    this.writeLinks(jgen, result.getRelationshipLinks(relationship.getFrom(), id, relationship.getType(resource)));
                    jgen.writeEndObject();
                }
            }
            jgen.writeEndObject();
        }
    }

    protected Object writeResourceIdentifierObject(JsonGenerator jgen, Resource<?, ?> resource, Object value) throws Exception {
        jgen.writeFieldName("data");
        String type = resource.getName();
        Object id = null;
        if (value instanceof Iterable) {
            jgen.writeStartArray();
            Iterator it = ((Iterable)value).iterator();
            while (it.hasNext()) {
                this.writeResourceIdentifierFields(jgen, type, it.next());
            }
            jgen.writeEndArray();
        } else {
            jgen.writeStartObject();
            id = this.writeResourceIdentifierFields(jgen, type, value);
            jgen.writeEndObject();
        }
        return id;
    }

    protected Object writeResourceIdentifierFields(JsonGenerator jgen, String type, Object id) throws Exception {
        jgen.writeStringField("type", type);
        return this.writeIdentifier(jgen, "id", id);
    }

    protected boolean hasRelationships(Map<PathValue, ?> paths) {
        for (Map.Entry<PathValue, ?> e : paths.entrySet()) {
            PathValue pv = e.getKey();
            if (!MappedFieldPathValue.isRelationshipField((PathValue)pv)) continue;
            return true;
        }
        return false;
    }

    protected void writeLinks(JsonGenerator jgen, Collection<Link> links) throws IOException {
        if (CollectionUtils.isNotEmpty(links)) {
            jgen.writeFieldName("links");
            LinksSerializer.writeLinksObject(jgen, links);
        }
    }
}

