/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.github.restup.controller.linking.BasicLink;
import com.github.restup.controller.linking.Link;
import com.github.restup.controller.linking.LinksResult;
import java.io.IOException;
import java.util.Collection;

public class LinksSerializer
extends JsonSerializer<LinksResult> {
    protected static void writeLinksObject(JsonGenerator jgen, Collection<Link> links) throws IOException {
        jgen.writeStartObject();
        for (Link link : links) {
            if (link instanceof BasicLink) {
                jgen.writeStringField(link.getName(), link.getHref());
                continue;
            }
            jgen.writeObjectField(link.getName(), (Object)link);
        }
        jgen.writeEndObject();
    }

    public void serialize(LinksResult result, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        LinksSerializer.writeLinksObject(jgen, result.getLinks());
    }
}

