/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.github.restup.controller.model.result.NegotiatedResult;
import com.github.restup.errors.ErrorCode;
import com.github.restup.errors.RequestError;
import com.github.restup.jackson.serializer.JsonResultSerializer;
import com.github.restup.mapping.fields.MappedField;
import com.github.restup.mapping.fields.ReadableField;
import com.github.restup.path.EmbeddedResourcePathValue;
import com.github.restup.path.IndexPathValue;
import com.github.restup.path.MappedFieldPathValue;
import com.github.restup.path.PathValue;
import com.github.restup.registry.Resource;
import com.github.restup.service.model.response.PagedResult;
import com.github.restup.service.model.response.ResourceResult;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NegotiatedResultSerializer<T extends NegotiatedResult>
extends JsonSerializer<T> {
    private static final Logger log = LoggerFactory.getLogger(JsonResultSerializer.class);

    public void serialize(T result, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (this.accept(result)) {
            try {
                jgen.writeStartObject();
                this.writeLinking(result, jgen, provider);
                this.writeData(result, jgen, provider);
                this.writeIncluded(result, jgen, provider);
                jgen.writeEndObject();
            }
            catch (Exception e) {
                log.error("Resource Object Serialization error", (Throwable)e);
                RequestError.error(((NegotiatedResult)result).getRequest().getResource(), (Throwable)e).code(ErrorCode.SERIALIZATION_ERROR).throwError();
            }
        } else {
            jgen.writeObject(((NegotiatedResult)result).getResult());
        }
    }

    protected boolean accept(T result) {
        return ((NegotiatedResult)result).getResult() instanceof ResourceResult;
    }

    protected void writeLinking(T result, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (((NegotiatedResult)result).getResult() instanceof PagedResult) {
            PagedResult paged = (PagedResult)((NegotiatedResult)result).getResult();
            this.writeIfNotNull(jgen, "limit", paged.getLimit());
            this.writeIfNotNull(jgen, "offset", paged.getOffset());
            this.writeIfNotNull(jgen, "total", paged.getTotal());
        }
    }

    protected void writeIncluded(T result, JsonGenerator jgen, SerializerProvider provider) throws IOException {
    }

    protected void writeData(T result, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        if (!((NegotiatedResult)result).isCount()) {
            Resource<?, ?> resource = ((NegotiatedResult)result).getResource();
            this.writeObjectField("data", resource, ((NegotiatedResult)result).getMappedPaths(), ((NegotiatedResult)result).getData(), result, jgen, provider);
        }
    }

    protected void writeObjectField(String fieldName, Resource<?, ?> resource, Map<PathValue, ?> paths, Object data, T result, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        jgen.writeFieldName(fieldName);
        this.writeObject(resource, paths, data, result, jgen, provider);
    }

    protected void writeObject(Resource<?, ?> resource, Map<PathValue, ?> paths, Object data, T result, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        if (data == null) {
            jgen.writeNull();
        } else if (data instanceof Iterable) {
            this.writeIterable(resource, paths, (Iterable)data, result, jgen, provider);
        } else if (data instanceof Object[]) {
            this.writeArray(resource, paths, (Object[])data, result, jgen, provider);
        } else if (resource != null) {
            this.writeResourceObject(resource, paths, data, result, jgen, provider);
        } else {
            jgen.writeStartObject();
            this.writeAttributes(resource, paths, data, result, jgen, provider, true);
            jgen.writeEndObject();
        }
    }

    protected void writeResourceObject(Resource<?, ?> resource, Map<PathValue, ?> paths, Object data, T result, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        jgen.writeStartObject();
        this.writeIdentifier(resource, data, result, jgen, provider);
        this.writeType(resource, data, result, jgen, provider);
        this.writeAttributes(resource, paths, data, result, jgen, provider, true);
        jgen.writeEndObject();
    }

    protected void writeIterable(Resource<?, ?> resource, Map<PathValue, ?> paths, Iterable<?> data, T result, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        jgen.writeStartArray();
        boolean indexed = this.writeIndexed(resource, paths, data, result, jgen, provider);
        if (!indexed) {
            Iterator<?> it = data.iterator();
            while (it.hasNext()) {
                this.writeObject(resource, paths, it.next(), result, jgen, provider);
            }
        }
        jgen.writeEndArray();
    }

    protected void writeArray(Resource<?, ?> resource, Map<PathValue, ?> paths, Object[] data, T result, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        jgen.writeStartArray();
        boolean indexed = this.writeIndexed(resource, paths, data, result, jgen, provider);
        if (!indexed) {
            for (Object o : data) {
                this.writeObject(resource, paths, o, result, jgen, provider);
            }
        }
        jgen.writeEndArray();
    }

    protected boolean writeIndexed(Resource<?, ?> resource, Map<PathValue, ?> paths, Object data, T result, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        boolean indexed = false;
        for (Map.Entry<PathValue, ?> e : paths.entrySet()) {
            PathValue pv = e.getKey();
            if (!(pv instanceof IndexPathValue) || !(e.getValue() instanceof Map)) continue;
            IndexPathValue i = (IndexPathValue)pv;
            Object value = i.readValue(data);
            this.writeObject(this.getResource(pv), this.asMap(e.getValue()), value, result, jgen, provider);
            indexed = true;
        }
        return indexed;
    }

    protected void writeType(Resource<?, ?> resource, Object data, T result, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStringField("type", resource.getName());
    }

    protected Object writeIdentifier(Resource<?, ?> resource, Object data, T result, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        MappedField field = resource.getIdentityField();
        Object id = field.readValue(data);
        this.writeIdentifier(jgen, field.getApiName(), id);
        return id;
    }

    protected Object writeIdentifier(JsonGenerator jgen, String fieldName, Object id) throws IOException {
        jgen.writeObjectField(fieldName, id);
        return id;
    }

    protected void writeAttributes(Resource<?, ?> resource, Map<PathValue, ?> paths, Object data, T result, JsonGenerator jgen, SerializerProvider provider, boolean writeRelationships) throws Exception {
        for (Map.Entry<PathValue, ?> e : paths.entrySet()) {
            PathValue pv = e.getKey();
            if (!(pv instanceof ReadableField) || !writeRelationships && MappedFieldPathValue.isRelationshipField((PathValue)pv)) continue;
            ReadableField readable = (ReadableField)pv;
            String fieldName = pv.getApiPath();
            Object value = readable.readValue(data);
            if (e.getValue() == null) {
                BeanPropertyWriter bpw = this.findBeanPropertyWriter(data, jgen, provider);
                if (bpw == null) {
                    JsonSerializer<Object> s = this.findCustomSerializer(pv, data, jgen, provider);
                    if (s == null) {
                        jgen.writeObjectField(fieldName, value);
                        continue;
                    }
                    s.serialize(value, jgen, provider);
                    continue;
                }
                bpw.serializeAsField(data, jgen, provider);
                continue;
            }
            if (!(e.getValue() instanceof Map)) continue;
            Resource<?, ?> pathResource = this.getResource(pv);
            this.writeObjectField(fieldName, pathResource, this.asMap(e.getValue()), value, result, jgen, provider);
        }
    }

    private Map<PathValue, ?> asMap(Object value) {
        return (Map)value;
    }

    protected Resource<?, ?> getResource(PathValue pv) {
        if (pv instanceof EmbeddedResourcePathValue) {
            return ((EmbeddedResourcePathValue)pv).getResource();
        }
        return null;
    }

    protected void writeIfNotNull(JsonGenerator jgen, String fieldName, Object value) throws IOException {
        if (value != null) {
            jgen.writeObjectField(fieldName, value);
        }
    }

    private BeanPropertyWriter findBeanPropertyWriter(Object data, JsonGenerator jgen, SerializerProvider provider) {
        return null;
    }

    private JsonSerializer<Object> findCustomSerializer(PathValue pv, Object data, JsonGenerator jgen, SerializerProvider provider) {
        return null;
    }
}

