/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.service.registry;

import com.github.restup.annotations.operations.AutoWrapDisabled;
import com.github.restup.annotations.operations.ListResource;
import com.github.restup.controller.linking.Link;
import com.github.restup.controller.linking.LinkBuilder;
import com.github.restup.controller.linking.LinkBuilderFactory;
import com.github.restup.controller.linking.LinksResult;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.registry.Resource;
import com.github.restup.registry.ResourceRegistry;
import java.util.ArrayList;
import java.util.Collection;

public class DiscoveryService {
    public static final String UP_RESOURCE_DISCOVERY = "Up!ResourceDiscovery";
    private final LinkBuilderFactory factory;

    public DiscoveryService(LinkBuilderFactory factory) {
        this.factory = factory;
    }

    @ListResource
    @AutoWrapDisabled
    public LinksResult listServicesForDiscovery(ParsedResourceControllerRequest<?> request, ResourceRegistry registry) {
        ArrayList<Link> result = new ArrayList<Link>();
        Collection<Resource<?, ?>> resources = this.getResources(registry);
        for (Resource<?, ?> resource : resources) {
            if (this.ignore(resource)) continue;
            LinkBuilder builder = this.factory.getLinkBuilder(request, resource);
            result.add(builder.getCollectionEndpoint(request, resource));
        }
        return new LinksResult(result);
    }

    protected boolean ignore(Resource<?, ?> resource) {
        return resource.getType() == Resource.class;
    }

    protected Collection<Resource<?, ?>> getResources(ResourceRegistry registry) {
        return registry.getResources();
    }
}

