/*
 * Messages.java
 * Copyright 2019 Rob Spoor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file has been generated by i18n-maven-plugin
// (https://robtimus.github.io/i18n-maven-plugin/)

package com.github.robtimus.net.ip;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

@SuppressWarnings("nls")
final class Messages {

    private static final Map<Locale, ResourceBundle> BUNDLES = new HashMap<>();

    private Messages() {
        throw new IllegalStateException("cannot create instances of " + getClass().getName());
    }

    private static synchronized ResourceBundle getResourceBundle(Locale locale) {
        Locale l = nonNull(locale);
        ResourceBundle bundle = BUNDLES.get(l);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("com.github.robtimus.net.ip.ip", l);
            BUNDLES.put(l, bundle);
        }
        return bundle;
    }

    private static String getString(Locale locale, String key) {
        ResourceBundle bundle = getResourceBundle(locale);
        return bundle.getString(key);
    }

    private static Locale nonNull(Locale locale) {
        return locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    static final IPAddress_ IPAddress = new IPAddress_();

    static final class IPAddress_ {

        private IPAddress_() {
            super();
        }

        final InvalidArraySize_ invalidArraySize = new InvalidArraySize_();

        static final class InvalidArraySize_ {

            private InvalidArraySize_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "IPAddress.invalidArraySize");
                return String.format(l, s, arg);
            }
        }

        final InvalidIPAddress_ invalidIPAddress = new InvalidIPAddress_();

        static final class InvalidIPAddress_ {

            private InvalidIPAddress_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "IPAddress.invalidIPAddress");
                return String.format(l, s, arg);
            }
        }

        final InvalidPrefixLength_ invalidPrefixLength = new InvalidPrefixLength_();

        static final class InvalidPrefixLength_ {

            private InvalidPrefixLength_() {
                super();
            }

            String get(
                    Object arg1,
                    Object arg2) {

                return get(null,
                        arg1,
                        arg2
                );
            }

            String get(Locale locale,
                    Object arg1,
                    Object arg2) {

                Locale l = nonNull(locale);
                String s = getString(l, "IPAddress.invalidPrefixLength");
                return String.format(l, s,
                        arg1,
                        arg2
                );
            }
        }

        final UnknownHost_ unknownHost = new UnknownHost_();

        static final class UnknownHost_ {

            private UnknownHost_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "IPAddress.unknownHost");
                return String.format(l, s, arg);
            }
        }

        final ParseError_ parseError = new ParseError_();

        static final class ParseError_ {

            private ParseError_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "IPAddress.parseError");
                return String.format(l, s, arg);
            }
        }
    }

    static final IPv4Address_ IPv4Address = new IPv4Address_();

    static final class IPv4Address_ {

        private IPv4Address_() {
            super();
        }

        final InvalidOctet_ invalidOctet = new InvalidOctet_();

        static final class InvalidOctet_ {

            private InvalidOctet_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "IPv4Address.invalidOctet");
                return String.format(l, s, arg);
            }
        }
    }

    static final IPv6Address_ IPv6Address = new IPv6Address_();

    static final class IPv6Address_ {

        private IPv6Address_() {
            super();
        }

        final InvalidHextet_ invalidHextet = new InvalidHextet_();

        static final class InvalidHextet_ {

            private InvalidHextet_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "IPv6Address.invalidHextet");
                return String.format(l, s, arg);
            }
        }

        final NotIPv4Mapped_ notIPv4Mapped = new NotIPv4Mapped_();

        static final class NotIPv4Mapped_ {

            private NotIPv4Mapped_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "IPv6Address.notIPv4Mapped");
                return String.format(l, s, arg);
            }
        }
    }

    static final IPRange_ IPRange = new IPRange_();

    static final class IPRange_ {

        private IPRange_() {
            super();
        }

        final ToSmallerThanFrom_ toSmallerThanFrom = new ToSmallerThanFrom_();

        static final class ToSmallerThanFrom_ {

            private ToSmallerThanFrom_() {
                super();
            }

            String get(
                    Object arg1,
                    Object arg2) {

                return get(null,
                        arg1,
                        arg2
                );
            }

            String get(Locale locale,
                    Object arg1,
                    Object arg2) {

                Locale l = nonNull(locale);
                String s = getString(l, "IPRange.toSmallerThanFrom");
                return String.format(l, s,
                        arg1,
                        arg2
                );
            }
        }
    }

    static final Subnet_ Subnet = new Subnet_();

    static final class Subnet_ {

        private Subnet_() {
            super();
        }

        final InvalidCIDRNotation_ invalidCIDRNotation = new InvalidCIDRNotation_();

        static final class InvalidCIDRNotation_ {

            private InvalidCIDRNotation_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "Subnet.invalidCIDRNotation");
                return String.format(l, s, arg);
            }
        }

        final InvalidNetmask_ invalidNetmask = new InvalidNetmask_();

        static final class InvalidNetmask_ {

            private InvalidNetmask_() {
                super();
            }

            String get(Object arg) {
                return get(null, arg);
            }

            String get(Locale locale, Object arg) {
                Locale l = nonNull(locale);
                String s = getString(l, "Subnet.invalidNetmask");
                return String.format(l, s, arg);
            }
        }

        final InvalidRoutingPrefix_ invalidRoutingPrefix = new InvalidRoutingPrefix_();

        static final class InvalidRoutingPrefix_ {

            private InvalidRoutingPrefix_() {
                super();
            }

            String get(
                    Object arg1,
                    Object arg2) {

                return get(null,
                        arg1,
                        arg2
                );
            }

            String get(Locale locale,
                    Object arg1,
                    Object arg2) {

                Locale l = nonNull(locale);
                String s = getString(l, "Subnet.invalidRoutingPrefix");
                return String.format(l, s,
                        arg1,
                        arg2
                );
            }
        }
    }
}
