/*
 * Messages.java
 * Copyright 2019 Rob Spoor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file has been generated by i18n-maven-plugin
// (https://robtimus.github.io/i18n-maven-plugin/)

package com.github.robtimus.net.ip;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

@SuppressWarnings("nls")
final class Messages {

    private static final Map<Locale, ResourceBundle> BUNDLES = new ConcurrentHashMap<>();

    private Messages() {
        throw new IllegalStateException("cannot create instances of " + getClass().getName());
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        Locale l = nonNull(locale);
        return BUNDLES.computeIfAbsent(l, k -> ResourceBundle.getBundle("com.github.robtimus.net.ip.ip", l));
    }

    private static String getString(Locale locale, String key) {
        ResourceBundle bundle = getResourceBundle(locale);
        return bundle.getString(key);
    }

    private static Locale nonNull(Locale locale) {
        return locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
    }

    static final IPAddress_ IPAddress = new IPAddress_();

    static final class IPAddress_ {

        private IPAddress_() {
            super();
        }

        String invalidArraySize(Object arg) {
            return invalidArraySize(null, arg);
        }

        String invalidArraySize(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPAddress.invalidArraySize");
            return String.format(l, s, arg);
        }

        String invalidIPAddress(Object arg) {
            return invalidIPAddress(null, arg);
        }

        String invalidIPAddress(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPAddress.invalidIPAddress");
            return String.format(l, s, arg);
        }

        String invalidPrefixLength(
            Object arg1,
            Object arg2) {

            return invalidPrefixLength(null,
                    arg1,
                    arg2
            );
        }

        String invalidPrefixLength(Locale locale,
                Object arg1,
                Object arg2) {

            Locale l = nonNull(locale);
            String s = getString(l, "IPAddress.invalidPrefixLength");
            return String.format(l, s,
                    arg1,
                    arg2
            );
        }

        String parseError(Object arg) {
            return parseError(null, arg);
        }

        String parseError(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPAddress.parseError");
            return String.format(l, s, arg);
        }
    }

    static final IPv4Address_ IPv4Address = new IPv4Address_();

    static final class IPv4Address_ {

        private IPv4Address_() {
            super();
        }

        String invalidIPv4Address(Object arg) {
            return invalidIPv4Address(null, arg);
        }

        String invalidIPv4Address(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPv4Address.invalidIPv4Address");
            return String.format(l, s, arg);
        }

        String invalidOctet(Object arg) {
            return invalidOctet(null, arg);
        }

        String invalidOctet(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPv4Address.invalidOctet");
            return String.format(l, s, arg);
        }

        String parseError(Object arg) {
            return parseError(null, arg);
        }

        String parseError(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPv4Address.parseError");
            return String.format(l, s, arg);
        }
    }

    static final IPv6Address_ IPv6Address = new IPv6Address_();

    static final class IPv6Address_ {

        private IPv6Address_() {
            super();
        }

        String invalidIPv6Address(Object arg) {
            return invalidIPv6Address(null, arg);
        }

        String invalidIPv6Address(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPv6Address.invalidIPv6Address");
            return String.format(l, s, arg);
        }

        String invalidHextet(Object arg) {
            return invalidHextet(null, arg);
        }

        String invalidHextet(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPv6Address.invalidHextet");
            return String.format(l, s, arg);
        }

        String notIPv4Mapped(Object arg) {
            return notIPv4Mapped(null, arg);
        }

        String notIPv4Mapped(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPv6Address.notIPv4Mapped");
            return String.format(l, s, arg);
        }

        String parseError(Object arg) {
            return parseError(null, arg);
        }

        String parseError(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPv6Address.parseError");
            return String.format(l, s, arg);
        }
    }

    static final IPAddressFormat_ IPAddressFormat = new IPAddressFormat_();

    static final class IPAddressFormat_ {

        private IPAddressFormat_() {
            super();
        }

        String unformattableObject(Object arg) {
            return unformattableObject(null, arg);
        }

        String unformattableObject(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "IPAddressFormat.unformattableObject");
            return String.format(l, s, arg);
        }
    }

    static final IPRange_ IPRange = new IPRange_();

    static final class IPRange_ {

        private IPRange_() {
            super();
        }

        String toSmallerThanFrom(
            Object arg1,
            Object arg2) {

            return toSmallerThanFrom(null,
                    arg1,
                    arg2
            );
        }

        String toSmallerThanFrom(Locale locale,
                Object arg1,
                Object arg2) {

            Locale l = nonNull(locale);
            String s = getString(l, "IPRange.toSmallerThanFrom");
            return String.format(l, s,
                    arg1,
                    arg2
            );
        }
    }

    static final Subnet_ Subnet = new Subnet_();

    static final class Subnet_ {

        private Subnet_() {
            super();
        }

        String invalidCIDRNotation(Object arg) {
            return invalidCIDRNotation(null, arg);
        }

        String invalidCIDRNotation(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "Subnet.invalidCIDRNotation");
            return String.format(l, s, arg);
        }

        String invalidNetmask(Object arg) {
            return invalidNetmask(null, arg);
        }

        String invalidNetmask(Locale locale, Object arg) {
            Locale l = nonNull(locale);
            String s = getString(l, "Subnet.invalidNetmask");
            return String.format(l, s, arg);
        }

        String invalidRoutingPrefix(
            Object arg1,
            Object arg2) {

            return invalidRoutingPrefix(null,
                    arg1,
                    arg2
            );
        }

        String invalidRoutingPrefix(Locale locale,
                Object arg1,
                Object arg2) {

            Locale l = nonNull(locale);
            String s = getString(l, "Subnet.invalidRoutingPrefix");
            return String.format(l, s,
                    arg1,
                    arg2
            );
        }
    }
}
