/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.ip.validation.validators;

import com.github.robtimus.net.ip.IPAddress;
import com.github.robtimus.net.ip.IPAddressFormatter;
import com.github.robtimus.net.ip.IPRange;
import com.github.robtimus.net.ip.validation.validators.IPAddressValidator;
import com.github.robtimus.net.ip.validation.validators.IPRangeParser;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Collection;

public class CharSequenceIPAddressValidator
implements ConstraintValidator<com.github.robtimus.net.ip.validation.IPAddress, CharSequence> {
    private String message;
    private Collection<IPRange<?>> ipRanges;

    public void initialize(com.github.robtimus.net.ip.validation.IPAddress constraintAnnotation) {
        this.message = constraintAnnotation.message();
        this.ipRanges = IPRangeParser.parseIPRanges(constraintAnnotation);
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.ipRanges.isEmpty()) {
            return IPAddress.isIPAddress((CharSequence)value);
        }
        return IPAddressFormatter.anyVersionWithDefaults().tryParse(value).map(ip -> IPAddressValidator.isValidIPAddress(ip, this.ipRanges, this.message, context)).orElse(false);
    }
}

