/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.ip.validation.validators;

import com.github.robtimus.net.ip.IPAddressFormatter;
import com.github.robtimus.net.ip.IPv4Address;
import com.github.robtimus.net.ip.IPv4Range;
import com.github.robtimus.net.ip.validation.validators.IPRangeParser;
import com.github.robtimus.net.ip.validation.validators.IPv4AddressValidator;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Collection;

public class CharSequenceIPv4AddressValidator
implements ConstraintValidator<com.github.robtimus.net.ip.validation.IPv4Address, CharSequence> {
    private String message;
    private Collection<IPv4Range> ipRanges;

    public void initialize(com.github.robtimus.net.ip.validation.IPv4Address constraintAnnotation) {
        this.message = constraintAnnotation.message();
        this.ipRanges = IPRangeParser.parseIPv4Ranges(constraintAnnotation);
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.ipRanges.isEmpty()) {
            return IPv4Address.isIPv4Address((CharSequence)value);
        }
        return IPAddressFormatter.ipv4().tryParse(value).map(ip -> IPv4AddressValidator.isValidIPv4Address(ip, this.ipRanges, this.message, context)).orElse(false);
    }
}

