/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.ip.validation.validators;

import com.github.robtimus.net.ip.IPAddressFormatter;
import com.github.robtimus.net.ip.IPv6Address;
import com.github.robtimus.net.ip.IPv6Range;
import com.github.robtimus.net.ip.validation.validators.IPRangeParser;
import com.github.robtimus.net.ip.validation.validators.IPv6AddressValidator;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Collection;

public class CharSequenceIPv6AddressValidator
implements ConstraintValidator<com.github.robtimus.net.ip.validation.IPv6Address, CharSequence> {
    private String message;
    private Collection<IPv6Range> ipRanges;

    public void initialize(com.github.robtimus.net.ip.validation.IPv6Address constraintAnnotation) {
        this.message = constraintAnnotation.message();
        this.ipRanges = IPRangeParser.parseIPv6Ranges(constraintAnnotation);
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.ipRanges.isEmpty()) {
            return IPv6Address.isIPv6Address((CharSequence)value);
        }
        return IPAddressFormatter.ipv6WithDefaults().tryParse(value).map(ip -> IPv6AddressValidator.isValidIPv6Address(ip, this.ipRanges, this.message, context)).orElse(false);
    }
}

