/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.ip.validation.validators;

import com.github.robtimus.net.ip.IPAddress;
import com.github.robtimus.net.ip.IPv6Range;
import com.github.robtimus.net.ip.validation.IPv6Address;
import com.github.robtimus.net.ip.validation.validators.IPRangeParser;
import com.github.robtimus.net.ip.validation.validators.IPv6AddressValidator;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Collection;

public class IPAddressIPv6AddressValidator
implements ConstraintValidator<IPv6Address, IPAddress<?>> {
    private String message;
    private Collection<IPv6Range> ipRanges;

    public void initialize(IPv6Address constraintAnnotation) {
        this.message = constraintAnnotation.message();
        this.ipRanges = IPRangeParser.parseIPv6Ranges(constraintAnnotation);
    }

    public boolean isValid(IPAddress<?> value, ConstraintValidatorContext context) {
        return value == null || IPv6AddressValidator.isValidIPv6Address(value, this.ipRanges, this.message, context);
    }
}

