/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.ip.validation.validators;

import com.github.robtimus.net.ip.IPAddress;
import com.github.robtimus.net.ip.IPRange;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Collection;

final class IPAddressValidator {
    private static final String DEFAULT_MESSAGE = "{com.github.robtimus.net.ip.validation.IPAddress.message}";
    private static final String MESSAGE_WITH_IP_RANGES = "{com.github.robtimus.net.ip.validation.IPAddress.message.withIPRanges}";

    private IPAddressValidator() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    static boolean isValidIPAddress(IPAddress<?> ipAddress, Collection<IPRange<?>> ipRanges, String message, ConstraintValidatorContext context) {
        if (ipRanges.isEmpty() || IPAddressValidator.ipRangesContainIPAddress(ipRanges, ipAddress)) {
            return true;
        }
        if (DEFAULT_MESSAGE.equals(message)) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(MESSAGE_WITH_IP_RANGES).addConstraintViolation();
        }
        return false;
    }

    private static boolean ipRangesContainIPAddress(Collection<IPRange<?>> ipRanges, IPAddress<?> ipAddress) {
        for (IPRange<?> ipRange : ipRanges) {
            if (!ipRange.contains(ipAddress)) continue;
            return true;
        }
        return false;
    }
}

