/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.ip.validation.validators;

import com.github.robtimus.net.ip.IPAddress;
import com.github.robtimus.net.ip.IPAddressFormatter;
import com.github.robtimus.net.ip.IPRange;
import com.github.robtimus.net.ip.IPv4Address;
import com.github.robtimus.net.ip.IPv4Range;
import com.github.robtimus.net.ip.IPv4Subnet;
import com.github.robtimus.net.ip.IPv6Address;
import com.github.robtimus.net.ip.IPv6Range;
import com.github.robtimus.net.ip.IPv6Subnet;
import com.github.robtimus.net.ip.Subnet;
import com.github.robtimus.net.ip.validation.validators.Messages;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

final class IPRangeParser {
    private IPRangeParser() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    static Collection<IPRange<?>> parseIPRanges(com.github.robtimus.net.ip.validation.IPAddress constraintAnnotation) {
        return Arrays.stream(constraintAnnotation.ipRanges()).map(IPRangeParser::parseIPRange).collect(Collectors.toList());
    }

    static IPRange<?> parseIPRange(String ipRange) {
        return IPRangeParser.parseIPRange(ipRange, Subnet::valueOf, IPAddressFormatter.anyVersionWithDefaults(), (from, to) -> IPRangeParser.createRange(from, to, ipRange));
    }

    private static <IP extends IPAddress<IP>> IPRange<?> createRange(IPAddress<?> from, IPAddress<?> to, String ipRange) {
        if (from.getClass() != to.getClass()) {
            throw new IllegalArgumentException(Messages.IPAddress.invalidIPRange(ipRange));
        }
        return from.to(to);
    }

    static Collection<IPv4Range> parseIPv4Ranges(com.github.robtimus.net.ip.validation.IPv4Address constraintAnnotation) {
        return Arrays.stream(constraintAnnotation.ipRanges()).map(IPRangeParser::parseIPv4Range).collect(Collectors.toList());
    }

    static IPv4Range parseIPv4Range(String ipRange) {
        return IPRangeParser.parseIPRange(ipRange, IPv4Subnet::valueOf, IPAddressFormatter.ipv4(), IPv4Address::to);
    }

    static Collection<IPv6Range> parseIPv6Ranges(com.github.robtimus.net.ip.validation.IPv6Address constraintAnnotation) {
        return Arrays.stream(constraintAnnotation.ipRanges()).map(IPRangeParser::parseIPv6Range).collect(Collectors.toList());
    }

    static IPv6Range parseIPv6Range(String ipRange) {
        return IPRangeParser.parseIPRange(ipRange, IPv6Subnet::valueOf, IPAddressFormatter.ipv6WithDefaults(), IPv6Address::to);
    }

    private static <IP extends IPAddress<?>, R extends IPRange<?>> R parseIPRange(String ipRange, Function<CharSequence, R> subnetParser, IPAddressFormatter<IP> formatter, BiFunction<IP, IP, R> ipRangeConstructor) {
        if (ipRange.indexOf(47) != -1) {
            return (R)((IPRange)subnetParser.apply(ipRange));
        }
        if (!ipRange.startsWith("[") || !ipRange.endsWith("]")) {
            throw new IllegalArgumentException(Messages.IPAddress.invalidIPRange(ipRange));
        }
        int index = ipRange.indexOf("...");
        if (index == -1) {
            throw new IllegalArgumentException(Messages.IPAddress.invalidIPRange(ipRange));
        }
        ParsePosition position = new ParsePosition(1);
        IPAddress from = formatter.parse((CharSequence)ipRange, position);
        if (from == null || position.getIndex() != index) {
            throw new IllegalArgumentException(Messages.IPAddress.invalidIPRange(ipRange));
        }
        position.setIndex(index + 3);
        IPAddress to = formatter.parse((CharSequence)ipRange, position);
        if (to == null || position.getIndex() != ipRange.length() - 1) {
            throw new IllegalArgumentException(Messages.IPAddress.invalidIPRange(ipRange));
        }
        return (R)((IPRange)ipRangeConstructor.apply(from, to));
    }
}

