/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.ip.validation.validators;

import com.github.robtimus.net.ip.IPAddress;
import com.github.robtimus.net.ip.IPv4Address;
import com.github.robtimus.net.ip.IPv4Range;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Collection;

final class IPv4AddressValidator {
    private static final String DEFAULT_MESSAGE = "{com.github.robtimus.net.ip.validation.IPv4Address.message}";
    private static final String MESSAGE_WITH_IP_RANGES = "{com.github.robtimus.net.ip.validation.IPv4Address.message.withIPRanges}";

    private IPv4AddressValidator() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    static boolean isValidIPv4Address(IPAddress<?> ipAddress, Collection<IPv4Range> ipRanges, String message, ConstraintValidatorContext context) {
        return ipAddress instanceof IPv4Address && IPv4AddressValidator.isValidIPv4Address((IPv4Address)ipAddress, ipRanges, message, context);
    }

    static boolean isValidIPv4Address(IPv4Address ipAddress, Collection<IPv4Range> ipRanges, String message, ConstraintValidatorContext context) {
        if (ipRanges.isEmpty() || IPv4AddressValidator.ipRangesContainIPv4Address(ipRanges, ipAddress)) {
            return true;
        }
        if (DEFAULT_MESSAGE.equals(message)) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(MESSAGE_WITH_IP_RANGES).addConstraintViolation();
        }
        return false;
    }

    private static boolean ipRangesContainIPv4Address(Collection<IPv4Range> ipRanges, IPv4Address ipAddress) {
        for (IPv4Range ipRange : ipRanges) {
            if (!ipRange.contains((IPAddress)ipAddress)) continue;
            return true;
        }
        return false;
    }
}

