/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.net.ip.validation.validators;

import com.github.robtimus.net.ip.IPAddress;
import com.github.robtimus.net.ip.IPv6Address;
import com.github.robtimus.net.ip.IPv6Range;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Collection;

final class IPv6AddressValidator {
    private static final String DEFAULT_MESSAGE = "{com.github.robtimus.net.ip.validation.IPv6Address.message}";
    private static final String MESSAGE_WITH_IP_RANGES = "{com.github.robtimus.net.ip.validation.IPv6Address.message.withIPRanges}";

    private IPv6AddressValidator() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    static boolean isValidIPv6Address(IPAddress<?> ipAddress, Collection<IPv6Range> ipRanges, String message, ConstraintValidatorContext context) {
        return ipAddress instanceof IPv6Address && IPv6AddressValidator.isValidIPv6Address((IPv6Address)ipAddress, ipRanges, message, context);
    }

    static boolean isValidIPv6Address(IPv6Address ipAddress, Collection<IPv6Range> ipRanges, String message, ConstraintValidatorContext context) {
        if (ipRanges.isEmpty() || IPv6AddressValidator.ipRangesContainIPv6Address(ipRanges, ipAddress)) {
            return true;
        }
        if (DEFAULT_MESSAGE.equals(message)) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(MESSAGE_WITH_IP_RANGES).addConstraintViolation();
        }
        return false;
    }

    private static boolean ipRangesContainIPv6Address(Collection<IPv6Range> ipRanges, IPv6Address ipAddress) {
        for (IPv6Range ipRange : ipRanges) {
            if (!ipRange.contains((IPAddress)ipAddress)) continue;
            return true;
        }
        return false;
    }
}

