/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.DoubleSupplier;

@FunctionalInterface
public interface DoubleSQLSupplier {
    public double getAsDouble() throws SQLException;

    public static DoubleSupplier unchecked(DoubleSQLSupplier supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.getAsDouble();
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static DoubleSQLSupplier checked(DoubleSupplier supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.getAsDouble();
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

