/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.DoubleToLongFunction;

@FunctionalInterface
public interface DoubleToLongSQLFunction {
    public long applyAsLong(double var1) throws SQLException;

    public static DoubleToLongFunction unchecked(DoubleToLongSQLFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsLong(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static DoubleToLongSQLFunction checked(DoubleToLongFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsLong(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

