/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;

@FunctionalInterface
public interface IntBinarySQLOperator {
    public int applyAsInt(int var1, int var2) throws SQLException;

    public static IntBinarySQLOperator unchecked(IntBinarySQLOperator operator) {
        Objects.requireNonNull(operator);
        return (left, right) -> {
            try {
                return operator.applyAsInt(left, right);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static IntBinarySQLOperator checked(IntBinarySQLOperator operator) {
        Objects.requireNonNull(operator);
        return (left, right) -> {
            try {
                return operator.applyAsInt(left, right);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

