/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.IntPredicate;

@FunctionalInterface
public interface IntSQLPredicate {
    public boolean test(int var1) throws SQLException;

    default public IntSQLPredicate and(IntSQLPredicate other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) && other.test(value);
    }

    default public IntSQLPredicate negate() {
        return value -> !this.test(value);
    }

    default public IntSQLPredicate or(IntSQLPredicate other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) || other.test(value);
    }

    public static IntPredicate unchecked(IntSQLPredicate predicate) {
        Objects.requireNonNull(predicate);
        return value -> {
            try {
                return predicate.test(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static IntSQLPredicate checked(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return value -> {
            try {
                return predicate.test(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

