/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.LongPredicate;

@FunctionalInterface
public interface LongSQLPredicate {
    public boolean test(long var1) throws SQLException;

    default public LongSQLPredicate and(LongSQLPredicate other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) && other.test(value);
    }

    default public LongSQLPredicate negate() {
        return value -> !this.test(value);
    }

    default public LongSQLPredicate or(LongSQLPredicate other) {
        Objects.requireNonNull(other);
        return value -> this.test(value) || other.test(value);
    }

    public static LongPredicate unchecked(LongSQLPredicate predicate) {
        Objects.requireNonNull(predicate);
        return value -> {
            try {
                return predicate.test(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static LongSQLPredicate checked(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return value -> {
            try {
                return predicate.test(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

