/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface SQLBiPredicate<T, U> {
    public boolean test(T var1, U var2) throws SQLException;

    default public SQLBiPredicate<T, U> and(SQLBiPredicate<? super T, ? super U> other) {
        Objects.requireNonNull(other);
        return (t, u) -> this.test(t, u) && other.test(t, u);
    }

    default public SQLBiPredicate<T, U> negate() {
        return (t, u) -> !this.test(t, u);
    }

    default public SQLBiPredicate<T, U> or(SQLBiPredicate<? super T, ? super U> other) {
        Objects.requireNonNull(other);
        return (t, u) -> this.test(t, u) || other.test(t, u);
    }

    public static <T, U> BiPredicate<T, U> unchecked(SQLBiPredicate<? super T, ? super U> predicate) {
        Objects.requireNonNull(predicate);
        return (t, u) -> {
            try {
                return predicate.test(t, u);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T, U> SQLBiPredicate<T, U> checked(BiPredicate<? super T, ? super U> predicate) {
        Objects.requireNonNull(predicate);
        return (t, u) -> {
            try {
                return predicate.test(t, u);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

