/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface SQLConsumer<T> {
    public void accept(T var1) throws SQLException;

    default public SQLConsumer<T> andThen(SQLConsumer<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    public static <T> Consumer<T> unchecked(SQLConsumer<? super T> operation) {
        Objects.requireNonNull(operation);
        return t -> {
            try {
                operation.accept(t);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T> SQLConsumer<T> checked(Consumer<? super T> operation) {
        Objects.requireNonNull(operation);
        return t -> {
            try {
                operation.accept(t);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

