/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface SQLFunction<T, R> {
    public R apply(T var1) throws SQLException;

    default public <V> SQLFunction<V, R> compose(SQLFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return t -> this.apply(before.apply((Object)t));
    }

    default public <V> SQLFunction<T, V> andThen(SQLFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    public static <T> SQLFunction<T, T> identity() {
        return t -> t;
    }

    public static <T, R> Function<T, R> unchecked(SQLFunction<? super T, ? extends R> function) {
        Objects.requireNonNull(function);
        return t -> {
            try {
                return function.apply(t);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T, R> SQLFunction<T, R> checked(Function<? super T, ? extends R> function) {
        Objects.requireNonNull(function);
        return t -> {
            try {
                return function.apply(t);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

