/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Predicate;

@FunctionalInterface
public interface SQLPredicate<T> {
    public boolean test(T var1) throws SQLException;

    default public SQLPredicate<T> and(SQLPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public SQLPredicate<T> negate() {
        return t -> !this.test(t);
    }

    default public SQLPredicate<T> or(SQLPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T> SQLPredicate<T> isEqual(Object targetRef) {
        return t -> Objects.equals(targetRef, t);
    }

    public static <T> Predicate<T> unchecked(SQLPredicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T> SQLPredicate<T> checked(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

