/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.ToIntBiFunction;

@FunctionalInterface
public interface ToIntSQLBiFunction<T, U> {
    public int applyAsInt(T var1, U var2) throws SQLException;

    public static <T, U> ToIntBiFunction<T, U> unchecked(ToIntSQLBiFunction<? super T, ? super U> function) {
        Objects.requireNonNull(function);
        return (t, u) -> {
            try {
                return function.applyAsInt(t, u);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T, U> ToIntSQLBiFunction<T, U> checked(ToIntBiFunction<? super T, ? super U> function) {
        Objects.requireNonNull(function);
        return (t, u) -> {
            try {
                return function.applyAsInt(t, u);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

