/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.SQLBiFunction;
import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BinaryOperator;

@FunctionalInterface
public interface BinarySQLOperator<T>
extends SQLBiFunction<T, T, T> {
    public static <T> BinarySQLOperator<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> BinarySQLOperator<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
    }

    public static <T> BinaryOperator<T> unchecked(BinarySQLOperator<T> operator) {
        Objects.requireNonNull(operator);
        return (a, b) -> {
            try {
                return operator.apply(a, b);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T> BinarySQLOperator<T> checked(BinaryOperator<T> operator) {
        Objects.requireNonNull(operator);
        return (a, b) -> {
            try {
                return operator.apply(a, b);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

