/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;

@FunctionalInterface
public interface DoubleBinarySQLOperator {
    public double applyAsDouble(double var1, double var3) throws SQLException;

    public static DoubleBinaryOperator unchecked(DoubleBinarySQLOperator operator) {
        Objects.requireNonNull(operator);
        return (left, right) -> {
            try {
                return operator.applyAsDouble(left, right);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static DoubleBinarySQLOperator checked(DoubleBinaryOperator operator) {
        Objects.requireNonNull(operator);
        return (left, right) -> {
            try {
                return operator.applyAsDouble(left, right);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

