/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;

@FunctionalInterface
public interface DoubleUnarySQLOperator {
    public double applyAsDouble(double var1) throws SQLException;

    default public DoubleUnarySQLOperator compose(DoubleUnarySQLOperator before) {
        Objects.requireNonNull(before);
        return operand -> this.applyAsDouble(before.applyAsDouble(operand));
    }

    default public DoubleUnarySQLOperator andThen(DoubleUnarySQLOperator after) {
        Objects.requireNonNull(after);
        return operand -> after.applyAsDouble(this.applyAsDouble(operand));
    }

    public static DoubleUnarySQLOperator identity() {
        return operand -> operand;
    }

    public static DoubleUnaryOperator unchecked(DoubleUnarySQLOperator operator) {
        Objects.requireNonNull(operator);
        return operand -> {
            try {
                return operator.applyAsDouble(operand);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static DoubleUnarySQLOperator checked(DoubleUnaryOperator operator) {
        Objects.requireNonNull(operator);
        return operand -> {
            try {
                return operator.applyAsDouble(operand);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

