/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.IntSupplier;

@FunctionalInterface
public interface IntSQLSupplier {
    public int getAsInt() throws SQLException;

    public static IntSupplier unchecked(IntSQLSupplier supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.getAsInt();
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static IntSQLSupplier checked(IntSupplier supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.getAsInt();
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

