/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.LongConsumer;

@FunctionalInterface
public interface LongSQLConsumer {
    public void accept(long var1) throws SQLException;

    default public LongSQLConsumer andThen(LongSQLConsumer after) {
        Objects.requireNonNull(after);
        return value -> {
            this.accept(value);
            after.accept(value);
        };
    }

    public static LongConsumer unchecked(LongSQLConsumer operation) {
        Objects.requireNonNull(operation);
        return value -> {
            try {
                operation.accept(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static LongSQLConsumer checked(LongConsumer operation) {
        Objects.requireNonNull(operation);
        return value -> {
            try {
                operation.accept(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

