/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.LongSupplier;

@FunctionalInterface
public interface LongSQLSupplier {
    public long getAsLong() throws SQLException;

    public static LongSupplier unchecked(LongSQLSupplier supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.getAsLong();
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static LongSQLSupplier checked(LongSupplier supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.getAsLong();
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

