/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.LongToDoubleFunction;

@FunctionalInterface
public interface LongToDoubleSQLFunction {
    public double applyAsDouble(long var1) throws SQLException;

    public static LongToDoubleFunction unchecked(LongToDoubleSQLFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsDouble(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static LongToDoubleSQLFunction checked(LongToDoubleFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsDouble(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

