/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.LongToIntFunction;

@FunctionalInterface
public interface LongToIntSQLFunction {
    public int applyAsInt(long var1) throws SQLException;

    public static LongToIntFunction unchecked(LongToIntSQLFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsInt(value);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static LongToIntSQLFunction checked(LongToIntFunction function) {
        Objects.requireNonNull(function);
        return value -> {
            try {
                return function.applyAsInt(value);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

