/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.SQLFunction;
import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.BiFunction;

@FunctionalInterface
public interface SQLBiFunction<T, U, R> {
    public R apply(T var1, U var2) throws SQLException;

    default public <V> SQLBiFunction<T, U, V> andThen(SQLFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return (t, u) -> after.apply((R)this.apply(t, u));
    }

    public static <T, U, R> BiFunction<T, U, R> unchecked(SQLBiFunction<? super T, ? super U, ? extends R> function) {
        Objects.requireNonNull(function);
        return (t, u) -> {
            try {
                return function.apply(t, u);
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T, U, R> SQLBiFunction<T, U, R> checked(BiFunction<? super T, ? super U, ? extends R> function) {
        Objects.requireNonNull(function);
        return (t, u) -> {
            try {
                return function.apply(t, u);
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

