/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;

public interface SQLRunnable {
    public void run() throws SQLException;

    public static Runnable unchecked(SQLRunnable action) {
        Objects.requireNonNull(action);
        return () -> {
            try {
                action.run();
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static SQLRunnable checked(Runnable action) {
        Objects.requireNonNull(action);
        return () -> {
            try {
                action.run();
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

