/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.sql.function;

import com.github.robtimus.sql.function.UncheckedSQLException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;

@FunctionalInterface
public interface SQLSupplier<T> {
    public T get() throws SQLException;

    public static <T> Supplier<T> unchecked(SQLSupplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.get();
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        };
    }

    public static <T> SQLSupplier<T> checked(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.get();
            }
            catch (UncheckedSQLException e) {
                throw e.getCause();
            }
        };
    }
}

