/*
 * Decompiled with CFR 0.152.
 */
package org.basicmon;

import org.basicmon.BasicMonStats;
import org.basicmon.util.BasicMonUtil;

public abstract class BasicMonBase {
    protected final String id;
    protected final boolean withStats;
    private BasicMonStats basicMonStats;

    public BasicMonBase(String id, boolean withStats) {
        this.id = id;
        if (withStats) {
            try {
                this.basicMonStats = new BasicMonStats();
            }
            catch (NoClassDefFoundError e) {
                this.withStats = false;
                return;
            }
        }
        this.withStats = withStats;
    }

    public final String getId() {
        return this.id;
    }

    public final boolean isWithStats() {
        return this.withStats;
    }

    public void reset() {
        if (this.withStats) {
            this.basicMonStats.reset();
        }
    }

    public abstract void increment();

    public abstract void decrement();

    public abstract void setVal(long var1);

    public abstract long getTotal();

    public abstract long getUpdateCount();

    public abstract double getMean();

    public final long getMin() {
        return this.withStats ? this.basicMonStats.getMin() : -1L;
    }

    public final long getMax() {
        return this.withStats ? this.basicMonStats.getMax() : -1L;
    }

    public final double getVariance() {
        return this.withStats ? this.basicMonStats.getVariance() : -1.0;
    }

    public abstract long getVal();

    public final double getStdDev() {
        if (!this.withStats) {
            return -1.0;
        }
        long total = this.getTotal();
        double variance = this.getVariance();
        return BasicMonUtil.calcStdDev(variance, total);
    }

    protected void updateStats(long val) {
        if (!this.withStats) {
            return;
        }
        this.basicMonStats.updateStats(val);
    }
}

